﻿if (typeof (question) === "undefined") {
    var question = {};
}

question.mid4078 = {
    //general options and settings
    opts: {
        questions: {
            hideByDefault: function () {
                var str = 'div[id$="TID1_QID4"],div[id$="TID1_QID6"]';

                return $(str);
            }
        }
    },

    //hide questions by default
    hideQuestions: function () {
        var _me = this;

        $.each(_me.opts.questions.hideByDefault(), function (i, _divQ) {

            //set 'skipped' attribute
            $(_divQ).attr('skipped', true);
            $('[name^="grp"]', $(_divQ)).each(function () {
                var _name = $(this).attr('name');
                if (_name.indexOf("skip_") < 0) {
                    $(this).attr("name", "skip_" + _name);
                }
            });

            //no need to reset question's responses as is the first time loading and there are no answers
            //_me.clearQuestionResponses(_divQ);

            //hide question
            $(_divQ).hide();

        });

    },

    //initializing functions
    init: function (callback) {
        var _me = this;

        //wait for DOM readiness
        $(document).ready(function () {
            Ext.onReady(function () {
                setTimeout(function () {
                    //call functions here
                    _me.hideQuestions();

                    //Successful
                    if (callback) {
                        if (typeof (callback.success) == "function") {
                            callback.success();
                        }
                    }
                }, 1);
            });
        });
    }
};